Dim AdjDir, MasterString, FitString2, EffString
Dim EffNum, EffStep, TextBoxSize, Spaces, Stars

Sub InitTextEffects2()
	TextBoxSize = 20
	for index = 1 to TextBoxSize
		Spaces = Spaces & " "
		Stars = Stars & "*"
	next 
End Sub


Function strLeft( text, size )
	if size < 0 then
		strLeft = ""
	else
		strLeft = Left( text, size )
	end if
End Function

Function strRight( text, size )
	if size < 0 then
		strRight = ""
	else
		strRight = Right( text, size )
	end if
End Function

Sub SetupText2( text, size )
	Dim temp, EdgeSize
	temp = Len(text)
	MasterString = text
	
	' By default, FitString should be a center-formatted copy of MasterString
	if Len(text) >= size then
		EdgeSize = (Len(text) - size) / 2
		FitString2 = Mid( text, EdgeSize+1, size )
	else
		FitString2 = strLeft( Spaces, (size - Len(text)) / 2) & text & Spaces
		FitString2 = strLeft( FitString2, size )
	End if
End Sub

Sub StartTextEffect2( EffectNum )
	Dim ok
	ok = true
	EffNum = EffectNum
	
	select case EffectNum
	case 1					' Scroll in from right
		EffStep = TextBoxSize
	case 2					' Scroll out from right
		EffStep = Len(MasterString)
	case 3					' Scroll across from right to left
		EffStep = Len(MasterString) + TextBoxSize
	case 4					' Scroll in from left
		EffStep = Len(MasterString)
	case 5					' Scroll out from left
		EffStep = TextBoxSize
	case 6					' Scroll across from left to right
		EffStep = TextBoxSize + Len(MasterString)
	case 7					' Wipe in from right
		EffStep = TextBoxSize
	case 8					' Wipe out from right
		EffStep = TextBoxSize
	case 9					' Wipe in from Left
		EffStep = TextBoxSize
	case 10					' Wipe out from left
		EffStep = TextBoxSize
	case 11					' Wipe in from center
		EffStep = Int(TextBoxSize / 2)
	case 12					' Wipe out from center
		EffStep = Int(TextBoxSize / 2)
	case 13					' Wipe in from edges
		EffStep = Int(TextBoxSize / 2)
	case 14					' Wipe out from edges
		EffStep = Int(TextBoxSize / 2)
	case 15					' Asterisks to text from center
		EffStep = TextBoxSize
	case 16					' Asterisks to blank from center
		EffStep = TextBoxSize
	case else
		PlaySound "Denied"
		ok = false
	end select
	
	if ok then TextTimer2.Enabled = true
End Sub

Sub TextTimer2_Timer()
	Dim seg1, seg2, halfsize
	halfsize = Int(TextBoxSize/2)
	
	select case EffNum
	case 1					' Scroll in from right
		EffString = strLeft( Spaces, EffStep ) & MasterString & Spaces

	case 2					' Scroll Out from Right
		EffString = strRight( MasterString, EffStep ) & Spaces
	
	case 3					' Scroll across from right
		seg2 = Len(MasterString)
		seg1 = EffStep - Len(MasterString)
		if seg1 < 0 then
			seg2 = Len(MasterString) + seg1
			seg1 = 0
		end if
		EffString = strLeft( Spaces, seg1 ) & strRight( MasterString, seg2 ) & Spaces
	
	case 4					' Scroll in from left
		EffString = strRight( MasterString, Len(MasterString) - EffStep) & Spaces
	
	case 5					' Scroll out from left
		EffString = strLeft( Spaces, TextBoxSize - EffStep ) & MasterString & Spaces
	
	case 6					' Scroll across from left
		seg2 = 0
		seg1 = EffStep - TextBoxSize
		if seg1 < 0 then
			seg2 = -seg1
			seg1 = 0
		end if
		EffString = strLeft( Spaces, seg2 ) & strRight( MasterString, Len(MasterString) - seg1 ) & Spaces

	case 7					' Wipe in from right
		EffString = strLeft( Spaces, EffStep ) & strRight( strLeft( MasterString & Spaces, TextBoxSize ), TextBoxSize - EffStep )

	case 8					' Wipe out from right
		EffString = strLeft( MasterString, EffStep ) & Spaces
		
	case 9					' Wipe in from left
		EffString = strLeft( MasterString, TextBoxSize - EffStep ) & Spaces
		
	case 10					' Wipe out from left
		EffString = strLeft( Spaces, TextBoxSize - EffStep ) & strRight( strLeft( MasterString & Spaces, TextBoxSize ), EffStep )
		
	case 11					' Wipe in from center
		seg1 = TextBoxSize - EffStep*2
		if seg1 < 0 then seg1 = 0
		EffString = strLeft( Spaces, EffStep ) & Mid( FitString2, EffStep+1, seg1 ) & Spaces
		
	case 12					' Wipe out from center
		EffString = strLeft( FitString2, EffStep ) & strLeft( Spaces, (TextBoxSize-2*EffStep) ) & strRight( FitString2, EffStep )
		
	case 13
		seg1 = halfsize - EffStep
		if seg1 < 0 then seg1 = 0
		EffString = strLeft( FitString2, seg1 ) & strLeft( Spaces, EffStep*2 ) & strRight( FitString2, halfsize - EffStep )
		
	case 14
		seg1 = halfsize - EffStep
		if seg1 < 0 then seg1 = 0
		
		EffString = strLeft( Spaces, seg1 ) & Mid( FitString2, seg1+1, EffStep*2 ) & Spaces
	
	case 15
		seg1 = EffStep - halfsize
		seg2 = 0
		if seg1 < 0 then
			seg2 = -seg1
			seg1 = 0
		end if
		
		if seg1 = 0 then
			EffString = strLeft( Stars, halfsize-seg2 ) & Mid( FitString2, halfsize-seg2 + 1, seg2*2 ) & Stars
		else
			EffString = strLeft( Spaces, seg1 ) & strLeft( Stars, (Int(TextBoxSize/2) - seg1)*2 ) & Spaces
		end if		
		
	case 16
		seg1 = EffStep - halfsize
		seg2 = 0
		if seg1 < 0 then
			seg2 = -seg1
			seg1 = 0
		end if
		
		if seg1 = 0 then
			EffString = strLeft( Stars, halfsize-seg2 ) & strLeft( Spaces, seg2*2 ) & Stars
		else
			EffString = strLeft( FitString, seg1 ) & strLeft( Stars, (halfsize-seg1)*2) & strRight( FitString, seg1 )
		end if		

	end select
	
	Textbox2.Text = Left( EffString, TextBoxSize )
	EffStep = EffStep - 1
	
	if EffStep < 0 then TextTimer.Enabled = false
End Sub


Sub AdjTimer2_Timer()
	if AdjDir <> 0 then
		TextTimer2.Interval = TextTimer2.Interval + AdjDir
		if TextTimer2.Interval < 20 then TextTimer2.Interval = 20
		if TextTimer2.Interval > 1500 then TextTimer2.Interval = 1500
	end if
End Sub
