VERSION 5.00
Object = "{2C1EC115-F1BA-11D3-BF43-00A0CC32BE58}#9.0#0"; "DMC2.ocx"
Object = "{F9043C88-F6F2-101A-A3C9-08002B2F49FB}#1.2#0"; "COMDLG32.OCX"
Begin VB.Form Form1 
   BorderStyle     =   1  'Fixed Single
   Caption         =   "Form1"
   ClientHeight    =   4305
   ClientLeft      =   45
   ClientTop       =   330
   ClientWidth     =   6330
   ClipControls    =   0   'False
   LinkTopic       =   "Form1"
   MaxButton       =   0   'False
   ScaleHeight     =   287
   ScaleMode       =   3  'Pixel
   ScaleWidth      =   422
   StartUpPosition =   3  'Windows Default
   Begin MSComDlg.CommonDialog CommDlg 
      Left            =   5970
      Top             =   45
      _ExtentX        =   847
      _ExtentY        =   847
      _Version        =   393216
      DialogTitle     =   "Open MP3/WAV file"
      Filter          =   "MP3 Music File|*.Mp3|WAV Music File|*.Wav"
   End
   Begin VB.CommandButton btn_OpenMP3 
      Height          =   375
      Left            =   5580
      MaskColor       =   &H00FFFFFF&
      Picture         =   "DMC2_Test.frx":0000
      Style           =   1  'Graphical
      TabIndex        =   22
      Top             =   165
      UseMaskColor    =   -1  'True
      Width           =   375
   End
   Begin VB.HScrollBar HScroll1 
      Height          =   225
      LargeChange     =   5
      Left            =   450
      Max             =   100
      MousePointer    =   9  'Size W E
      TabIndex        =   21
      Top             =   1545
      Width           =   3060
   End
   Begin VB.Timer Timer2 
      Interval        =   1000
      Left            =   5595
      Top             =   585
   End
   Begin DMC2.DMC DMC 
      Left            =   6030
      Top             =   585
      _ExtentX        =   423
      _ExtentY        =   423
   End
   Begin VB.CommandButton btn_ResumeMP3 
      Caption         =   "Resume"
      Enabled         =   0   'False
      Height          =   375
      Left            =   3870
      TabIndex        =   18
      Top             =   600
      Width           =   825
   End
   Begin VB.CommandButton btn_PauseMP3 
      Caption         =   "Pause"
      Enabled         =   0   'False
      Height          =   375
      Left            =   3030
      TabIndex        =   17
      Top             =   600
      Width           =   825
   End
   Begin VB.HScrollBar hsPan 
      Height          =   225
      Left            =   1065
      Max             =   100
      Min             =   -100
      TabIndex        =   11
      Top             =   3840
      Width           =   5025
   End
   Begin VB.HScrollBar hsFreq 
      Height          =   225
      LargeChange     =   100
      Left            =   1065
      Max             =   25000
      Min             =   25
      TabIndex        =   10
      Top             =   3600
      Value           =   11025
      Width           =   5025
   End
   Begin VB.HScrollBar hsVolume 
      Height          =   225
      Left            =   1065
      Max             =   100
      TabIndex        =   9
      Top             =   3360
      Value           =   100
      Width           =   5025
   End
   Begin VB.Timer Timer1 
      Enabled         =   0   'False
      Interval        =   50
      Left            =   5850
      Top             =   810
   End
   Begin VB.CommandButton btn_StopMP3 
      Caption         =   "Stop"
      Enabled         =   0   'False
      Height          =   375
      Left            =   4710
      TabIndex        =   2
      Top             =   600
      Width           =   825
   End
   Begin VB.CommandButton btn_PlayMP3 
      Caption         =   "Play"
      Height          =   375
      Left            =   2190
      TabIndex        =   1
      Top             =   600
      Width           =   825
   End
   Begin VB.TextBox txt_MP3File 
      Height          =   285
      Left            =   1155
      TabIndex        =   0
      Text            =   "G:\MMFusion\Apps\aie.mp3"
      Top             =   210
      Width           =   4380
   End
   Begin VB.Frame Frame1 
      Height          =   1065
      Left            =   930
      TabIndex        =   15
      Top             =   3120
      Width           =   5325
   End
   Begin VB.Line Line5 
      X1              =   398
      X2              =   252
      Y1              =   100
      Y2              =   100
   End
   Begin VB.Label lblSetPos 
      Alignment       =   1  'Right Justify
      Height          =   225
      Left            =   45
      TabIndex        =   23
      Top             =   1560
      Width           =   375
   End
   Begin VB.Label lbl_RightLev 
      Alignment       =   1  'Right Justify
      BackStyle       =   0  'Transparent
      Caption         =   "Right Channel"
      Height          =   225
      Left            =   5190
      TabIndex        =   6
      Top             =   2340
      Width           =   1050
   End
   Begin VB.Label lbl_LeftLev 
      Alignment       =   1  'Right Justify
      BackStyle       =   0  'Transparent
      Caption         =   "Left Channel"
      Height          =   195
      Left            =   5190
      TabIndex        =   5
      Top             =   2070
      Width           =   1050
   End
   Begin VB.Label Label9 
      Alignment       =   2  'Center
      Caption         =   "The Playing Files Properties"
      Height          =   255
      Left            =   3525
      TabIndex        =   20
      Top             =   1560
      Width           =   2730
   End
   Begin VB.Label Label8 
      Alignment       =   2  'Center
      Caption         =   "Time Elapsed"
      Height          =   210
      Left            =   3585
      TabIndex        =   19
      Top             =   1260
      Width           =   2595
   End
   Begin VB.Label lblDone 
      Alignment       =   2  'Center
      BackStyle       =   0  'Transparent
      Caption         =   "0% Done"
      Height          =   240
      Left            =   1635
      TabIndex        =   16
      Top             =   1245
      Width           =   750
   End
   Begin VB.Shape shpDone 
      FillColor       =   &H0080FF80&
      FillStyle       =   0  'Solid
      Height          =   240
      Left            =   480
      Top             =   1230
      Width           =   3000
   End
   Begin VB.Shape Shape3 
      FillColor       =   &H00FF80FF&
      FillStyle       =   0  'Solid
      Height          =   300
      Left            =   450
      Top             =   1200
      Width           =   3060
   End
   Begin VB.Label Label7 
      Alignment       =   1  'Right Justify
      Caption         =   "Panning:"
      Height          =   210
      Left            =   180
      TabIndex        =   14
      Top             =   3840
      Width           =   735
   End
   Begin VB.Label Label6 
      Alignment       =   1  'Right Justify
      Caption         =   "Frequency:"
      Height          =   210
      Left            =   -15
      TabIndex        =   13
      Top             =   3615
      Width           =   915
   End
   Begin VB.Label Label5 
      Alignment       =   1  'Right Justify
      Caption         =   "Volume:"
      Height          =   210
      Left            =   180
      TabIndex        =   12
      Top             =   3405
      Width           =   735
   End
   Begin VB.Label Label4 
      Alignment       =   2  'Center
      Caption         =   "Stream Properties"
      Height          =   255
      Left            =   1515
      TabIndex        =   8
      Top             =   2940
      Width           =   3660
   End
   Begin VB.Line Line4 
      X1              =   1
      X2              =   424
      Y1              =   183
      Y2              =   183
   End
   Begin VB.Line Line3 
      BorderColor     =   &H00FFFFFF&
      X1              =   0
      X2              =   425
      Y1              =   184
      Y2              =   184
   End
   Begin VB.Shape Shape2 
      Height          =   255
      Left            =   15
      Top             =   2325
      Width           =   6315
   End
   Begin VB.Shape Shape1 
      Height          =   255
      Left            =   15
      Top             =   2040
      Width           =   6315
   End
   Begin VB.Line Line2 
      BorderColor     =   &H00FFFFFF&
      X1              =   0
      X2              =   425
      Y1              =   124
      Y2              =   124
   End
   Begin VB.Line Line1 
      X1              =   1
      X2              =   424
      Y1              =   123
      Y2              =   123
   End
   Begin VB.Label Label3 
      Caption         =   "MP3 File:"
      Height          =   255
      Left            =   435
      TabIndex        =   7
      Top             =   240
      Width           =   735
   End
   Begin VB.Label Label2 
      Caption         =   "Position"
      Height          =   255
      Left            =   435
      TabIndex        =   4
      Top             =   840
      Width           =   1575
   End
   Begin VB.Label Label1 
      Caption         =   "Length"
      Height          =   255
      Left            =   435
      TabIndex        =   3
      Top             =   600
      Width           =   1575
   End
   Begin VB.Image imgLeft 
      Height          =   225
      Left            =   30
      Picture         =   "DMC2_Test.frx":060A
      Top             =   2055
      Width           =   6300
   End
   Begin VB.Image imgRight 
      Height          =   225
      Left            =   30
      Picture         =   "DMC2_Test.frx":12DF
      Top             =   2340
      Width           =   6300
   End
End
Attribute VB_Name = "Form1"
Attribute VB_GlobalNameSpace = False
Attribute VB_Creatable = False
Attribute VB_PredeclaredId = True
Attribute VB_Exposed = False

Dim strTotalTime As String

Private Sub btn_OpenMP3_Click()

    CommDlg.ShowOpen
    txt_MP3File.Text = CommDlg.filename

End Sub

Private Sub btn_PauseMP3_Click()

    DMC.PauseStream
    btn_PauseMP3.Enabled = False
    btn_ResumeMP3.Enabled = True

End Sub

Private Sub btn_PlayMP3_Click()
Dim time As Double
Dim Minutes As Integer, Seconds As Integer
Dim strMinutes As String, strSeconds As String


    DMC.OpenStream txt_MP3File.Text
    DMC.PlayStream False

    Timer1.Enabled = True
    btn_ResumeMP3.Enabled = False
    btn_PauseMP3.Enabled = True
    btn_StopMP3.Enabled = True

    Label9.Caption = ""

    If DMC.StreamIsMono = True Then
        Label9.Caption = "Mono"
    Else
        Label9.Caption = "Stereo"
    End If
    
    If DMC.StreamIs8bit = True Then
        Label9.Caption = Label9.Caption & " - 8 bit - " & DMC.StreamFreq & " Hz"
    Else
        Label9.Caption = Label9.Caption & " - 16 bit - " & DMC.StreamFreq & " Hz"
    End If


    'lets save the Lenght Now... so we don't have to  waste CPU time later.
    time = DMC.StreamLenInSeconds
    Minutes = time / 60
    Seconds = (time Mod 60)
    
    If Seconds > 30 Then
        Minutes = Minutes - 1
    End If
    
    'much faster way
    If Minutes < 10 Then strMinutes = "0" & Minutes Else strMinutes = Minutes
    If Seconds < 10 Then strSeconds = "0" & Seconds Else strSeconds = Seconds
    
    strTotalTime = strMinutes & ":" & strSeconds    'save it here


End Sub

Private Sub btn_ResumeMP3_Click()

    DMC.ResumeStream
    Timer1.Enabled = True
    btn_PauseMP3.Enabled = True
    btn_ResumeMP3.Enabled = False

End Sub

Private Sub btn_StopMP3_Click()

    DMC.StopStream
    Timer1.Enabled = False
    btn_PauseMP3.Enabled = False
    btn_ResumeMP3.Enabled = False
    btn_StopMP3.Enabled = False

End Sub

Private Sub DMC_StreamStoped(ByVal paused As Boolean)

    Debug.Print "StreamStoped EVENT Was RAISED... Paused = " & paused

End Sub

Private Sub Form_Load()

'--its already Initialized on form3--
'
'    DMC.InitBASS Me.hWnd, 44100, True, True
'

End Sub

Private Sub Form_Unload(Cancel As Integer)

    Cancel = True
    Me.Visible = False
    DMC.CloseStream

End Sub

Private Sub HScroll1_Change()
Dim pos As Long

pos = DMC.StreamLen / 100 * HScroll1.Value

If pos > 0 Then
    DMC.StreamPos = pos
Else
    DMC.StreamPos = 0
End If

lblSetPos.Caption = ""

End Sub

Private Sub HScroll1_Scroll()

    lblSetPos.Caption = HScroll1.Value & "%"

End Sub

Private Sub hsFreq_Change()
Dim time As Double
Dim Minutes As Integer, Seconds As Integer
Dim strMinutes As String, strSeconds As String

    DMC.StreamFreq = hsFreq.Value * 4&


    'lets find the Lenght Again.. since the time lenght has changed
    'since the frequency has changed...
    time = DMC.StreamLenInSeconds
    Minutes = time / 60
    Seconds = (time Mod 60)
    
    If Seconds > 30 Then
        Minutes = Minutes - 1
    End If
    
    'much faster way
    If Minutes < 10 Then strMinutes = "0" & Minutes Else strMinutes = Minutes
    If Seconds < 10 Then strSeconds = "0" & Seconds Else strSeconds = Seconds
    
    strTotalTime = strMinutes & ":" & strSeconds    'save it here

End Sub

Private Sub hsPan_Change()

    DMC.StreamPan = hsPan.Value

End Sub

Private Sub hsVolume_Change()

    DMC.StreamVol = hsVolume.Value

End Sub

Private Sub Timer1_Timer()
Static left&, right&, len1&, pos1&, per_done&

    If DMC.StreamIsActive = True Then
    
        len1 = DMC.StreamLen
        pos1 = DMC.StreamPos
        Label1.Caption = "Len: " & len1
        Label2.Caption = "Pos: " & pos1
        left = DMC.StreamLeftLevel
        right = DMC.StreamRightLevel
        lbl_LeftLev.Caption = left
        lbl_RightLev.Caption = right
        
        imgLeft.Width = left * 3.3
        imgRight.Width = right * 3.3
        
        Label4.Caption = "Freq:" & DMC.StreamFreq & _
            "   Vol:" & DMC.StreamVol & "   Pan:" & DMC.StreamPan

        per_done = pos1 / (len1 / 100)
        'Debug.Print len1 / 100
        lblDone.Caption = per_done & " %"
        shpDone.Width = per_done * 2
             
    Else
        Timer1.Enabled = False
        btn_PauseMP3.Enabled = False
    
    End If

End Sub


Private Sub Timer2_Timer()
Dim time As Double
Dim Minutes As Integer, Seconds As Integer
Dim strMinutes As String, strSeconds As String

    If DMC.StreamIsActive Then
        time = DMC.StreamPosInSeconds
        Minutes = time / 60
        Seconds = time Mod 60
        If Seconds > 30 Then
            Minutes = Minutes - 1
        End If
        
        'much faster way
        If Minutes < 10 Then strMinutes = "0" & Minutes Else strMinutes = Minutes
        If Seconds < 10 Then strSeconds = "0" & Seconds Else strSeconds = Seconds
        
        Label8.Caption = strMinutes & ":" & strSeconds & " -- " & strTotalTime
    Else
        time = 0
    End If

End Sub

